require 'rubygems'
require 'watir-webdriver'
require 'page-object'
require_relative '../base/base'
require_relative '../../common/common'
require_relative '../../helper/modal'

class BookedAppointmentDetail < Base
  include PageObject

  def initialize(driver)
    super(driver)
    @common = Common.new(@driver)
    @modal = Modal.new(@driver)
  end

  h2(:title, :css => '.primary-header h2')

  expected_title "Appointment Details"

  #calendar icon
  button(:add_to_calendar, :id =>"add-to-calendar-btn")
  span(:calendar_icon, :css=>".icon-calendar-plus")

  div(:appointment_status_group, :id => 'appointment-status-group')
  div(:appointment_details_group, :css => '#appointment-details-section')
  #button(:cancel_btn, :id =>'cancel-appointment-btn')
  p(:status_desc, :css=>'.appointment-status-desc')

  div(:cancel_reason_section, :css => '#cancel-confirmation')
  radio_button_group(:need_to_cancel_appointment, :name=>'cancelAppointment')
  radio_button(:cancel_yes, :id=>'cancelAppointment-yes')
  radio_button(:cancel_no, :id=>'cancelAppointment-no')
  select_list(:reason_for_cancel, :id=>'cancelReason')
  button(:cancel_appointment, :id => 'cancel-booked-appointment-btn')
  elements(:cancel_reasons, :css=>'#cancelReason option')
  button(:confirm_cancellation, :id=>'cancel-appointment-btn')
  button(:close_without_cancelling, :id=>'cancel-return-btn')

  p(:required, :css => 'div.ui-content p')

  p(:cancel_by_contacting_facility_message, :id=>'appointment-cancel-by-contacting-facility-message')

  link(:feedbackLink, :css=>'a[href="#feedback"]')
  ## Cancel Appointment modal
  h3(:cancel_appointment_header, :id=>'dialogTitle')

  def isConfirmationDisplayed?
    dialogueDisplayed = false
    Watir::Wait.until {self.appointment_details_group_element.present?}
    Watir::Wait.until {self.appointment_details_group_element.text.include?("Reason for Appointment")}
    if self.appointment_details_group_element.present?
      dialogueDisplayed = true
    end
    return dialogueDisplayed
  end

  def clickCancelAppointment
    wait_until{ !cancel_appointment_element.attribute('disabled') }
    cancel_appointment_element.when_present(TIME_OUT_LIMIT)
    cancel_appointment
    @common.waitWhileSpinnerPresent
    @modal.modalTitle_element.when_present(TIME_OUT_LIMIT)
  end

  def selectReasonForCancellation(reason)
    wait_until{ !reason_for_cancel_element.attribute('disabled') }
    reason_for_cancel_element.when_present(TIME_OUT_LIMIT)
    options = self.cancel_reasons_elements
    selectOption(options, reason)
    @common.waitWhileSpinnerPresent
  end

  def clickConfirmCancellation
    wait_until{ !confirm_cancellation_element.attribute('disabled') }
    confirm_cancellation_element.when_present(TIME_OUT_LIMIT)
    button_element = @driver.button(:id => 'cancel-appointment-btn')
    @driver.execute_script("$(arguments[0]).click();",button_element)
    @common.waitWhileSpinnerPresent
    @modal.modalTitle_element.when_present(TIME_OUT_LIMIT)
  end

  def clickCloseWithoutCancelling
    wait_until{ !close_without_cancelling_element.attribute('disabled') }
    close_without_cancelling_element.when_present(TIME_OUT_LIMIT)
    close_without_cancelling
    @common.waitWhileSpinnerPresent
  end

end
